RDF1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>
  <rdf:Description rdf:about='http://spam.com/a'>
    <rdf:value rdf:resource="ftss://spam.com/b"/>
  </rdf:Description>
</rdf:RDF>
"""

EXPECTED1 = """<?xml version="1.0" encoding="UTF-8"?>
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="http://spam.com/a">
    <rdf:value rdf:resource="ftss://spam.com/b"/>
  </rdf:Description>
</rdf:RDF>"""


def Test(tester):
    from cStringIO import StringIO
    from Ft.Lib.Uri import OsPathToUri
    from Ft.Rdf import Util
    from Ft.Xml.Domlette import PrettyPrint
    from Ft.Xml.Lib import TreeCompare

    tester.startTest('Deserialize and reserialize')
    scope = OsPathToUri(__file__, attemptAbsolute=True)
    scope += '-INTERNAL-XML-STRING'
    model, db = Util.DeserializeFromString(RDF1, scope=scope)
    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    stream = StringIO()
    doc = serializer.serialize(model)
    PrettyPrint(doc, stream)
    tester.compare(stream.getvalue(), EXPECTED1, func=TreeCompare.TreeCompare)
    tester.testDone()

