
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Module
from Ft.Ods.MetaData import Interface
from Ft.Ods.MetaData import Class
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_metaobject
import test_definingscope
import test_metadata_util

def Test(tester,useKlass=Module.Module):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    
    try:
        test_metaobject.Test(tester,db,useKlass)
        test_definingscope.Test(tester,db,useKlass)

        tester.startGroup("Module Interface %s Driver" % tester.test_data['driver'])


        test_metadata_util.test_add_remove(tester,db,useKlass,'module',
                                           ("Module",),
                                           argFactory={},
                                           argListFactory={},
                                           argResolve={},
                                           testValues={"name":"Module",
                                                       "meta_kind":MetaKind.mk_module,
                                                       },
                                           testListValues={},
                                           testIn="defines",
                                           testResolve="Module",
                                           )

        def CreateInherits(db,values):
            from Ft.Ods.MetaData import Interface
            inherits = Interface.Interface(db,None)
            inherits.name = "Mo"
            return inherits
        test_metadata_util.test_add_remove(tester,db,useKlass,'interface',
                                           ("Interface","Inherits"),
                                           argFactory={},
                                           argListFactory={"Inherits":CreateInherits},
                                           argResolve={},
                                           testValues={"name":"Interface",
                                                       "meta_kind":MetaKind.mk_interface,
                                                       },
                                           testListValues={"inherits":"Inherits"},
                                           testIn="defines",
                                           testResolve="Interface",
                                           )
        def CreateInherits(db,values):
            from Ft.Ods.MetaData import Interface
            inherits = Interface.Interface(db,None)
            inherits.name = "Mo2"
            return inherits
        def CreateExtend(db,values):
            from Ft.Ods.MetaData import Class
            inherits = Class.Class(db,None)
            inherits.name = "Mo4"
            return inherits
        test_metadata_util.test_add_remove(tester,db,useKlass,'class',
                                           ("Class","Inherits","Extend"),
                                           argFactory={"Extend":CreateExtend},
                                           argListFactory={"Inherits":CreateInherits},
                                           argResolve={},
                                           testValues={"name":"Class",
                                                       "meta_kind":MetaKind.mk_class,
                                                       "extender":"Extend"
                                                       },
                                           testListValues={"inherits":"Inherits"},
                                           testIn="defines",
                                           testResolve="Class",
                                           )

        tester.groupDone()
    finally:

        db.close()


