
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Attribute
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_property
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    try:
        test_property.Test(tester,db,Attribute.Attribute)


        tester.startGroup("Attribute Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_primitive_type(tester,db,Attribute.Attribute,'is_read_only',1)
        tester.groupDone()
    finally:
        db.close()



