
import sys, os
p = os.path.join("..","..")
sys.path.append(p)
import profile_util

def do_create():
    repo = profile_util.GetRepo()
    repo.createDocument('/profile/doc',XML_SRC)
    repo.txCommit()
   

NUM_CHILDREN = 2500
XML_SRC = """<docelem><one>Foo</one>%s<two>Bar</two></docelem>""" % ("<child/>"*NUM_CHILDREN)

NUM_DOCS = 100

def do_profile():
    #Init
    repo = profile_util.GetRepo()
    if repo.hasResource('/profile'):
        repo.deleteResource('/profile')
    p = repo.createContainer('/profile',1)

    #Add a bunch of other documents
    for ctr in range(NUM_DOCS):
        p.createDocument('doc%d'%ctr,'<foo/>')

    repo.txCommit()

    profile_util.run("do_create()",globals(),locals())


if __name__ == '__main__':
    profile_util.InitRepo()
    do_profile()
