#ifndef DOMLETTE_ATTR_H
#define DOMLETTE_ATTR_H

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "node.h"

  typedef struct {
    PyNode_HEAD
    PyObject *namespaceURI;
    PyObject *prefix;
    PyObject *localName;
    PyObject *nodeName;
    PyObject *nodeValue;
  } PyAttrObject;

#define PyAttr_NAMESPACE_URI(op) (((PyAttrObject *)(op))->namespaceURI)
#define PyAttr_PREFIX(op) (((PyAttrObject *)(op))->prefix)
#define PyAttr_LOCAL_NAME(op) (((PyAttrObject *)(op))->localName)
#define PyAttr_NODE_NAME(op) (((PyAttrObject *)(op))->nodeValue)
#define PyAttr_NODE_VALUE(op) (((PyAttrObject *)(op))->nodeValue)

  extern PyTypeObject DomletteAttr_Type;

#define PyAttr_Check(op) ((op)->ob_type == &DomletteAttr_Type)

  /* Module Methods */
  int DomletteAttr_Init(PyObject *module);
  void DomletteAttr_Fini(void);

  /* Attr Methods */
  PyAttrObject *Attr_CloneNode(PyObject *node, int deep,
                               PyNodeObject *newOwnerDocument);

#ifdef __cplusplus
}
#endif

#endif /* DOMLETTE_ATTR_H */
