<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f	"http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
  <!ENTITY vcard "http://4suite.org/nexus/rdfs/vcard#">
]>
<xsl:stylesheet
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:fcore="http://xmlns.4suite.org/4ss/score" 
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" 
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;" 
  xmlns:fres="&fres;"
  xmlns:rdf="&rdf;" 
  xmlns:f="&f;" 
  xmlns:vcard="&vcard;" 
  xmlns:fschema="http://schemas.4suite.org/4ss"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <!--
File:  start.xslt

Description:

    Shuffle two decks of cards and deal them


WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->

  <xsl:import href='../common/cards.xslt'/>
  <xsl:output method='html'/>
  <xsl:param name='user-name'/>


  <xsl:template match='/'>
    <!-- Shuffle a new deck -->
    <xsl:variable name='deck'>
      <xsl:call-template name='shuffle-cards'>
        <xsl:with-param name='num-decks' select='2'/>
      </xsl:call-template>
    </xsl:variable>

    <!-- now deal em -->
    <xsl:variable name='dealt'>
      <xsl:call-template name='deal-cards'>
        <xsl:with-param name='card-node' select='exslt:node-set($deck)/Card[1]'/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name='new-id' select='f:generate-uuid()'/>

    <fcore:create-document base-path='games' path='{$new-id}'>
      <loritaire>
        <cards>
          <target/>
          <target/>
          <target/>
          <target/>
          <target/>
          <target/>
          <target/>
          <target/>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-1"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-2"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-3"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-4"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-5"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-6"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-7"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-8"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-9"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-10"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-11"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-12"]'/>
          </pile>
          <pile>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Pile-13"]'/>
          </pile>
          <stack>
            <xsl:copy-of select='exslt:node-set($dealt)/Card[@position="Stack"]'/>
          </stack>
        </cards>
        <cur-hand>-1</cur-hand>
      </loritaire>
    </fcore:create-document>

    <fhttp:response-uri uri="games/{$new-id}?xslt=../play.xslt&amp;user-name={$user-name}"/>

    <fcore:mark-temporary path="games/{$new-id}" time-to-live="900"/>

  </xsl:template>


  <xsl:template match='Card'>
    <tr>
      <td>
        <xsl:value-of select='position()'/>
      </td>
      <td>
        <IMG src='{@img}'/>
      </td>
      <td>
        <xsl:value-of select='@weight'/>
      </td>
      <td>
        <xsl:value-of select='@suite'/>
      </td>
      <td>
        <xsl:value-of select='@value'/>
      </td>
      <td>
        <xsl:value-of select='@point'/>
      </td>
      <td>
        <xsl:value-of select='@position'/>
      </td>
    </tr>
  </xsl:template>


  <xsl:template name="deal-cards">
    <xsl:param name="card-node" select="/.."/>
    <xsl:param name='cur-pos' select='1'/>
    <xsl:param name='force-stack' select='0'/>

    <xsl:variable name='position'>
      <xsl:choose>
        <xsl:when test='$force-stack > 0'>
          <xsl:text>Stack</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>Pile-</xsl:text><xsl:value-of select='$cur-pos'/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name='next-force-stack'>
      <xsl:choose>
        <xsl:when test='$force-stack > 0'>
          <xsl:value-of select='$force-stack - 1'/>
        </xsl:when>
        <xsl:when test='$card-node/@value-int = 1'>
          <xsl:choose>
            <xsl:when test='$cur-pos = 1'>2</xsl:when>
            <xsl:when test='$cur-pos = 7'>2</xsl:when>
            <xsl:when test='$cur-pos = 13'>2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test='$card-node/@value-int = 13'>
          <xsl:choose>
            <xsl:when test='$cur-pos = 13'>4</xsl:when>
            <xsl:when test='$cur-pos = 7'>3</xsl:when>
            <xsl:otherwise>2</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test='$card-node/@value-int = $cur-pos and $cur-pos = 7'>2</xsl:when>
            <xsl:when test='$card-node/@value-int = $cur-pos'>1</xsl:when>
            <xsl:when test='$cur-pos = 7'>1</xsl:when>
            <xsl:when test='$cur-pos = 13'>1</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name='next-pos'>
      <xsl:choose>
        <xsl:when test='$next-force-stack > 0'>
          <xsl:value-of select='$cur-pos'/>
        </xsl:when>
        <xsl:when test='$cur-pos = 13'>1</xsl:when>
        <xsl:otherwise><xsl:value-of select='$cur-pos + 1'/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <Card>
      <xsl:copy-of select='$card-node/@*'/>
      <xsl:attribute name='position'>
        <xsl:value-of select='$position'/>
      </xsl:attribute>
    </Card>

    <!-- note: tail recursion optimizations only work with named templates! -->
    <xsl:if test='$card-node/following-sibling::Card'>
      <xsl:call-template name='deal-cards'>
        <xsl:with-param name='card-node' select='$card-node/following-sibling::Card[1]'/>
        <xsl:with-param name='cur-pos' select='normalize-space($next-pos)'/>
        <xsl:with-param name='force-stack' select='$next-force-stack'/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
