<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Count routines

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->


  <xsl:template name='count-non-dealer'>
    <xsl:param name='cur-dealer'/>
    <!--
      Count the non dealers hand first
    -->

    <xsl:variable name='non-dealer' select='number($cur-dealer = 1) + 1'/>

    <xsl:variable name='cards'>
      <xsl:for-each select='/cribbage/player-info/player[@ID=number($non-dealer)]/cards/Card'>
        <xsl:copy-of select='.'/>
      </xsl:for-each>
      <xsl:copy-of select='/cribbage/game-info/cut-card/Card'/>
    </xsl:variable>

    <!-- count the non dealer's hand -->

    <xsl:variable name='count-res'>
      <xsl:call-template name='count-hand'>
        <xsl:with-param name='cards' select='exslt:node-set($cards)/Card'/>
        <xsl:with-param name='draw' select='/cribbage/game-info/cut-card/Card'/>
        <xsl:with-param name='is-crib' select='0'/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='number($non-dealer)'/>
      <xsl:with-param name='message' select='"Hand:"'/>
    </xsl:call-template>

    <xsl:apply-templates select='exslt:node-set($count-res)/CribbageCount/*' mode='award-points'>
      <xsl:with-param name='player' select='number($non-dealer)'/>
    </xsl:apply-templates>

    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='number($non-dealer)'/>
      <xsl:with-param name='message' select='concat("Total: ",string(exslt:node-set($count-res)/CribbageCount/@total))'/>
    </xsl:call-template>

  </xsl:template>



  <xsl:template name='count-dealer'>
    <xsl:param name='cur-dealer'/>

    <xsl:variable name='dealer-cards'>
      <xsl:for-each select='/cribbage/player-info/player[@ID=number($cur-dealer)]/cards/Card'>
        <xsl:copy-of select='.'/>
      </xsl:for-each>
      <xsl:copy-of select='/cribbage/game-info/cut-card/Card'/>
    </xsl:variable>


    <xsl:variable name='dealer-count-res'>
      <xsl:call-template name='count-hand'>
        <xsl:with-param name='cards' select='exslt:node-set($dealer-cards)/Card'/>
        <xsl:with-param name='draw' select='/cribbage/game-info/cut-card/Card'/>
        <xsl:with-param name='is-crib' select='0'/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='number($cur-dealer)'/>
      <xsl:with-param name='message' select='"Hand:"'/>
    </xsl:call-template>

    <xsl:apply-templates select='exslt:node-set($dealer-count-res)/CribbageCount/*' mode='award-points'>
      <xsl:with-param name='player' select='number($cur-dealer)'/>
    </xsl:apply-templates>

    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='number($cur-dealer)'/>
      <xsl:with-param name='message' select='concat("Total: ",string(exslt:node-set($dealer-count-res)/CribbageCount/@total))'/>
    </xsl:call-template>


    <!-- count the dealer's crib -->
    <xsl:variable name='dealer-crib-cards'>
      <xsl:for-each select='/cribbage/crib-info/Card'>
        <xsl:copy-of select='.'/>
      </xsl:for-each>
      <xsl:copy-of select='/cribbage/game-info/cut-card/Card'/>
    </xsl:variable>


    <xsl:variable name='dealer-crib-count-res'>
      <xsl:call-template name='count-hand'>
        <xsl:with-param name='cards' select='exslt:node-set($dealer-crib-cards)/Card'/>
        <xsl:with-param name='draw' select='/cribbage/game-info/cut-card/Card'/>
        <xsl:with-param name='is-crib' select='1'/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='number($cur-dealer)'/>
      <xsl:with-param name='message' select='"Crib:"'/>
    </xsl:call-template>

    <xsl:apply-templates select='exslt:node-set($dealer-crib-count-res)/CribbageCount/*' mode='award-points'>
      <xsl:with-param name='player' select='number($cur-dealer)'/>
    </xsl:apply-templates>

    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='number($cur-dealer)'/>
      <xsl:with-param name='message' select='concat("Total: ",string(exslt:node-set($dealer-crib-count-res)/CribbageCount/@total))'/>
    </xsl:call-template>

  </xsl:template>

</xsl:stylesheet>
