########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/Container.py,v 1.15 2004/09/23 20:53:29 mbrown Exp $
"""
Implementation of '4ss fetch container' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command produces a directory-like listing of the \
resources that are the children of a Container in a 4Suite repository. \
Columns in the listing include: Internet Media Type, size in bytes, \
date last modified, and resource's relative name. If necessary, you \
will be prompted first for credentials and access info to connect to \
the repository."""

import sys

from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import ResourceTypes


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.fetch.container')
    if repo is not None:
        try:
            container = repo.fetchResource(args.get('path', '/'))
            if container.isResourceType(ResourceTypes.ResourceType.CONTAINER):
                sty = repo.fetchResource('/ftss/data/cl-container.xslt')
                print container.applyXslt([sty])[0]
            else:
                #FIXME: use FtServerClientException?
                sys.stderr.write("The resource '%s' is not a container.\n" % container.getPath())
                sys.stderr.flush()
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('container',
                          'List contents of a Container in a repository',
                          '/ftss/data',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.OptionalArgument('path',
                                                                  'the path of the Container (default: /)',
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd
