########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Create/RawFile.py,v 1.20 2004/10/09 03:06:23 mbrown Exp $
"""
Implementation of '4ss create rawfile' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command creates a new Raw File resource in a 4Suite \
repository. A Raw File is used to store non-XML based data in the \
repository. If you are storing XML data, please see the '4ss create \
document' command. If necessary, you will be prompted first for \
credentials and access info to connect to the repository."""

import sys

from Ft.Lib import Uri
from Ft.Lib.CommandLine.CommandLineUtil import SourceArgToInputSource
from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Xml.InputSource import DefaultFactory


def Run(options, args):
    sourceUri = args['source-uri']
    try:
        source_isrc = SourceArgToInputSource(sourceUri, DefaultFactory)
    except ValueError, e:
        sys.stderr.write(str(e)+'\n')
        sys.stderr.flush()
        return

    content = source_isrc.read()
    source_isrc.close()

    path = args['path']
    aliases = args.get('alias',[])
    imt = options.get('imt', 'text/plain')

    repo = CommandUtil.GetRepository(options,'4ss.create.rawfile')
    if repo is not None:
        commit = False
        try:
            doc = repo.createRawFile(path, imt, content)
            for alias in aliases:
                doc.addAlias(alias)

            commit = True
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('rawfile',
                          'Create a new Raw File in a repository',
                          '--imt=image/jpeg /images/4suite.jpg /local/path/to/4Suite.jpg',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('path',
                                                                  "The repo path of the Raw File to create",
                                                                  str),
                                       Arguments.RequiredArgument('source-uri',
                                                                  "The URI to read the file's content from, or '-' for stdin",
                                                                  str),
                                       Arguments.ZeroOrMoreArgument('alias',
                                                                    "Additional aliases to assign to the new file.",
                                                                    str),
                                       ],
                          options = Options.Options([Options.Option(None,
                                                                    'imt=',
                                                                    'The file\'s Internet Media Type. Default: text/plain.'),
                                                     ]),
                          fileName = __file__,
                          )
    return cmd
