#ifndef __APTSEARCHPLUGIN_H_2004_06_21
#define __APTSEARCHPLUGIN_H_2004_06_21


#include <string>

#include <HandleMaker.h>

#include <searchplugin.h>

#include "aptpackages.h"

class QTimer;
class QStatusBar;

class AptSearchPluginShortInputWidget;

using namespace std;

namespace NPlugin
{

// Class AptSearchPlugin
// 
// 
class AptSearchPlugin : public SearchPlugin 
{
	Q_OBJECT
	const QString _title;
	const QString _briefDescription;
	const QString _description;
	Tagcoll::HandleMaker<string>* _pHandleMaker;
	/** This holds the result of the currently active search. */
	Tagcoll::OpSet<int> _searchResult;
	/** This holds a link to the manager which manages the plugin. */
	IProvider* _pProvider;
	/** Holds a pointer to the main widgets status bar. */
	QStatusBar* _pStatusBar;
	/** This timer is used to delay the evaluation of the search a little to avoid unneccessary operations
	  * e.g. on text input. */
	QTimer* _pDelayTimer;
	/** This is the delay time in ms the delay timer waits for another input. */
	uint _delayTime;
	/** The cache access data structure this plugin uses to access the apt database. */
//	const CacheAccess& _ca;
	/** The short widget used for getting the user input. */
	AptSearchPluginShortInputWidget* _pShortInputWidget;
	
	/** Holds the interface used for searching. */
	NApt::IAptSearch* _pAptSearch;
	/** Holds the patterns that must be contained in the text to be searched. */
	QStringList _includePatterns;
	/** Holds the patterns that must not be contained in the text to be searched. */
	QStringList _excludePatterns;
protected slots:
	/** This evaluates the search as specified in the input widgets. */
	virtual void evaluateSearch();
	/** This is called whenever the text of the widget where to insert the 
	  * search pattern changes. */
	void onInputTextChanged(const QString&);
protected:
	/** This parses the handed search expression. 
	  *
	  * It fills #_includePatterns and #_excludePatterns;
	  */
	void parseSearchExpression(const QString& expression);

public:
	AptSearchPlugin(NApt::IAptSearch* pAptSearch);
	virtual ~AptSearchPlugin();
	/** @name Plugin Interface
	  * 
	  * Implementation of the PluginInterface
	  */
	//@{
	/**
	  * 
	  * @param pluginManager the search window this plugin is added to
	  * @param window The QT-Mainwindow where the Plugins will be diplayed. This can be 
	  * used to get e.g. status bar, toolbar, etc
	  */
	virtual void init(IProvider* pProvider);
	/// @todo not yet implemented
	virtual void setEnabled(bool enabled)	{};
	/// @todo not yet implemented
	virtual void setVisible(bool visible)	{};
	virtual QString title() const { return _title; };
	virtual QString briefDescription() const { return _briefDescription; };
	virtual QString description() const { return _description; };
	//@}
	/** @name SearchPlugin interface
	  * 
	  * Implementation of the SearchPlugin interface
	  */
	//@{
	/** @brief This plugin offers no input widgets. */
	virtual QWidget* inputWidget() const { return 0; };
	/** @brief This plugin offers no input widgets.  */
	virtual QString inputWidgetTitle() const { return _emptyString; };
	virtual QWidget* shortInputAndFeedbackWidget() const;
	virtual void clearSearch();
	virtual bool usesFilterTechnique() const { return false; };
	virtual const Tagcoll::OpSet<int>& searchResult() const	{ return _searchResult; };
	virtual bool filterPackage(int packageID) const	{ return true; };
	virtual bool isInactive() const;
	virtual uint searchPriority() const { return 1; };
	//@}
	/** @brief Returns the list of patterns currently searched for by the AptSearchPlugin.
	  *
	  * @returns the list of patterns currently searched for or an empty list if no searched
	  * is active
	  */
	QStringList searchPatterns();

};

}	// namespace NPlugin


#endif //	__APTSEARCHPLUGIN_H_2004_06_21

