/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi.iiop;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;

import javax.management.NotificationListener;
import javax.rmi.PortableRemoteObject;

import mx4j.tools.connector.rmi.RemoteNotificationListenerSupport;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class IIOPRemoteNotificationListenerSupport extends RemoteNotificationListenerSupport
{
	public IIOPRemoteNotificationListenerSupport(NotificationListener clientListener)
	{
		super(clientListener);
	}

	public void export() throws RemoteException
	{
		PortableRemoteObject.exportObject(getRemoteNotificationListener());
	}

	public void unexport() throws NoSuchObjectException
	{
		PortableRemoteObject.unexportObject(getRemoteNotificationListener());
	}
}
