/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management.monitor;

import java.util.HashMap;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;

/**
 *
 *
 * @see Monitor
 * @author <a href="mailto:tibu@users.sourceforge.net">Carlos Quiroz</a>
 * @version $Revision: 1.5 $
 */
public class StringMonitor extends Monitor implements StringMonitorMBean
{
	private String stringToCompare;

	private boolean notifyMatch, notifyDiffers;

	private static final MBeanNotificationInfo[] notificationInfos =
	{
		new MBeanNotificationInfo(new String[]
			{
				MonitorNotification.RUNTIME_ERROR,
				MonitorNotification.OBSERVED_OBJECT_ERROR,
				MonitorNotification.OBSERVED_ATTRIBUTE_ERROR,
				MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR,
				MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED,
				MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED
			}
		, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")
	};

        private HashMap infos = new HashMap();

	public synchronized void start()
	{
		doStart();
	}

	public synchronized void stop() {
		doStop();
	}

	synchronized void executeMonitor(ObjectName objectName, Object attributeValue)
	{
            StringMonitorInfo smi = (StringMonitorInfo)infos.get(objectName);
		if (smi.getLastValue() != null && smi.getLastValue().equals(attributeValue))
		{
			return;
		}
		if (stringToCompare == null)
		{
			getLogger().info(new StringBuffer("Monitor ").append(this).append(" target value is null"));
			notifyListeners("jmx.notification.error.type", objectName, attribute);
		}
		if (!(attributeValue instanceof String))
		{
			getLogger().info(new StringBuffer("Monitor ").append(this).append(" attribute is not String"));
			notifyListeners("jmx.notification.error.type", objectName, attribute);
			return;
		}
		calculateDerivedGauge(smi,(String)attributeValue);
		boolean matches = attributeValue.equals(stringToCompare);
		smi.setLastValue((String) attributeValue);
		if (notifyMatch && matches)
		{
			getLogger().info(new StringBuffer("Monitor ").append(this).append(" found a match"));
			notifyListeners(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, objectName, attribute);
		}
		if (notifyDiffers && !matches)
		{
			getLogger().info(new StringBuffer("Monitor ").append(this).append(" found a difference"));
			notifyListeners(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, objectName, attribute);
		}
	}

	void calculateDerivedGauge(StringMonitorInfo smi, String value)
	{
		smi.setDerivedGauge(value);
		smi.setDerivedGaugeTimestamp(System.currentTimeMillis());
	}

        /**
         * @deprecated
         */
	public synchronized String getDerivedGauge()
	{
            if(objectNames.size() == 0) return null;
            return getDerivedGauge((ObjectName)objectNames.get(0));
	}
        public synchronized String getDerivedGauge(ObjectName objectName) {
            if(objectNames.size() == 0) return null;
            return ((StringMonitorInfo)infos.get(objectName)).getDerivedGauge();
        }


        /**
         * @deprecated
         */
        public synchronized long getDerivedGaugeTimeStamp()
	{
            if(objectNames.size() == 0) return 0;
            return getDerivedGaugeTimeStamp((ObjectName)objectNames.get(0));
	}

        public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
            if(objectNames.size() == 0) return 0;
            return ((StringMonitorInfo)infos.get(objectName)).getDerivedGaugeTimestamp();
        }

	public String getStringToCompare()
	{
		return stringToCompare;
	}

	public void setStringToCompare(String value) throws java.lang.IllegalArgumentException
	{
		if (value == null)
		{
			throw new IllegalArgumentException("Cannot compare to null");
		}
                synchronized(this){
                    resetLastValue();
                }
		this.stringToCompare = value;
	}

	public boolean getNotifyMatch()
	{
		return notifyMatch;
	}

	public synchronized void setNotifyMatch(boolean value)
	{
		resetLastValue();
		this.notifyMatch = value;
	}

	public boolean getNotifyDiffer()
	{
		return notifyDiffers;
	}

	public synchronized void setNotifyDiffer(boolean value)
	{
		resetLastValue();
		this.notifyDiffers = value;
	}

	public MBeanNotificationInfo[] getNotificationInfo()
	{
		return notificationInfos;
	}

	public String toString()
	{
		return new StringBuffer("StringMonitor on ").append(super.toString()).toString();
	}

        public synchronized void addObservedObject(ObjectName objectName)  throws java.lang.IllegalArgumentException {
            super.addObservedObject(objectName);
            infos.put(objectName,new StringMonitorInfo(null, System.currentTimeMillis()));
        }

        public synchronized void removeObservedObject(ObjectName objectName){
            super.removeObservedObject(objectName);
            infos.remove(objectName);
        }

        private void resetLastValue(){
            for(int i = 0; i < objectNames.size(); i++){
                StringMonitorInfo smi = (StringMonitorInfo)infos.get(objectNames.get(i));
                smi.setLastValue(null);
            }
        }

        class StringMonitorInfo{
            String derivedGauge;
            String lastValue;
            long derivedGaugeTimestamp;

            public StringMonitorInfo(String derivedGauge, long derivedGaugeTimestamp){
                this.derivedGauge = derivedGauge;
                this.derivedGaugeTimestamp = derivedGaugeTimestamp;
                this.lastValue = null;
            }

            /** Getter for property derivedGauge.
             * @return Value of property derivedGauge.
             *
             */
            public java.lang.String getDerivedGauge() {
                return derivedGauge;
            }

            /** Setter for property derivedGauge.
             * @param derivedGauge New value of property derivedGauge.
             *
             */
            public void setDerivedGauge(java.lang.String derivedGauge) {
                this.derivedGauge = derivedGauge;
            }

            /** Getter for property derivedGaugeTimestamp.
             * @return Value of property derivedGaugeTimestamp.
             *
             */
            public long getDerivedGaugeTimestamp() {
                return derivedGaugeTimestamp;
            }

            /** Setter for property derivedGaugeTimestamp.
             * @param derivedGaugeTimestamp New value of property derivedGaugeTimestamp.
             *
             */
            public void setDerivedGaugeTimestamp(long derivedGaugeTimestamp) {
                this.derivedGaugeTimestamp = derivedGaugeTimestamp;
            }

            /** Getter for property lastValue.
             * @return Value of property lastValue.
             *
             */
            public java.lang.String getLastValue() {
                return lastValue;
            }

            /** Setter for property lastValue.
             * @param lastValue New value of property lastValue.
             *
             */
            public void setLastValue(java.lang.String lastValue) {
                this.lastValue = lastValue;
            }

        }

}
