/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Get
extends Task {
    private URL source;
    private File dest;
    private boolean verbose = false;
    private boolean useTimestamp = false;
    private boolean ignoreErrors = false;
    private String uname = null;
    private String pword = null;
    static /* synthetic */ Class array$B;

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.location);
        }
        if (this.dest == null) {
            throw new BuildException("dest attribute is required", this.location);
        }
        if (this.dest.exists() && this.dest.isDirectory()) {
            throw new BuildException("The specified destination is a directory", this.location);
        }
        if (this.dest.exists() && !this.dest.canWrite()) {
            throw new BuildException("Can't write to " + this.dest.getAbsolutePath(), this.location);
        }
        try {
            boolean finished;
            InputStream is;
            URLConnection connection;
            block32: {
                this.log("Getting: " + this.source);
                long timestamp = 0L;
                boolean hasTimestamp = false;
                if (this.useTimestamp && this.dest.exists()) {
                    timestamp = this.dest.lastModified();
                    if (this.verbose) {
                        Date t = new Date(timestamp);
                        this.log("local file date : " + t.toString());
                    }
                    hasTimestamp = true;
                }
                connection = this.source.openConnection();
                if (this.useTimestamp && hasTimestamp) {
                    connection.setIfModifiedSince(timestamp);
                }
                if (this.uname != null || this.pword != null) {
                    String encoding;
                    String up = this.uname + ":" + this.pword;
                    try {
                        Object encoder = Class.forName("sun.misc.BASE64Encoder").newInstance();
                        encoding = (String)encoder.getClass().getMethod("encode", array$B == null ? (array$B = Get.class$("[B")) : array$B).invoke(encoder, new Object[]{up.getBytes()});
                    }
                    catch (Exception ex) {
                        Base64Converter encoder = new Base64Converter();
                        encoding = encoder.encode(up.getBytes());
                    }
                    connection.setRequestProperty("Authorization", "Basic " + encoding);
                }
                connection.connect();
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    if (httpConnection.getResponseCode() == 304) {
                        this.log("Not modified - so not downloaded");
                        return;
                    }
                    if (httpConnection.getResponseCode() == 401) {
                        String message = "HTTP Authorization failure";
                        if (this.ignoreErrors) {
                            this.log(message, 1);
                            return;
                        }
                        throw new BuildException(message);
                    }
                }
                is = null;
                int i = 0;
                while (i < 3) {
                    try {
                        is = connection.getInputStream();
                        break;
                    }
                    catch (IOException ex) {
                        this.log("Error opening connection " + ex);
                        ++i;
                    }
                }
                if (is == null) {
                    this.log("Can't get " + this.source + " to " + this.dest);
                    if (this.ignoreErrors) {
                        return;
                    }
                    throw new BuildException("Can't get " + this.source + " to " + this.dest, this.location);
                }
                FileOutputStream fos = new FileOutputStream(this.dest);
                finished = false;
                try {
                    int length;
                    byte[] buffer = new byte[102400];
                    while ((length = is.read(buffer)) >= 0) {
                        void var10_15;
                        fos.write(buffer, 0, (int)var10_15);
                        if (!this.verbose) continue;
                        System.out.print(".");
                    }
                    if (this.verbose) {
                        System.out.println();
                    }
                    finished = true;
                    Object var12_16 = null;
                    if (fos == null) break block32;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    if (fos != null) {
                        fos.close();
                    }
                    is.close();
                    if (!finished) {
                        this.dest.delete();
                    }
                    throw throwable;
                }
                fos.close();
            }
            is.close();
            if (!finished) {
                this.dest.delete();
            }
            if (this.useTimestamp) {
                long remoteTimestamp = connection.getLastModified();
                if (this.verbose) {
                    Date t = new Date(remoteTimestamp);
                    this.log("last modified = " + t.toString() + (remoteTimestamp == 0L ? " - using current time instead" : ""));
                }
                if (remoteTimestamp != 0L) {
                    FileUtils.newFileUtils().setFileLastModified(this.dest, remoteTimestamp);
                }
            }
        }
        catch (IOException ioe) {
            this.log("Error getting " + this.source + " to " + this.dest);
            if (this.ignoreErrors) {
                return;
            }
            throw new BuildException(ioe, this.location);
        }
    }

    public void setSrc(URL u) {
        this.source = u;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setIgnoreErrors(boolean v) {
        this.ignoreErrors = v;
    }

    public void setUseTimestamp(boolean v) {
        if (!JavaEnvUtils.isJavaVersion("1.1")) {
            this.useTimestamp = v;
        }
    }

    public void setUsername(String u) {
        this.uname = u;
    }

    public void setPassword(String p) {
        this.pword = p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Base64Converter {
        public final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        Base64Converter() {
        }

        public String encode(String s) {
            return this.encode(s.getBytes());
        }

        public String encode(byte[] octetString) {
            int bits6;
            int bits24;
            char[] out = new char[((octetString.length - 1) / 3 + 1) * 4];
            int outIndex = 0;
            int i = 0;
            while (i + 3 <= octetString.length) {
                bits24 = (octetString[i++] & 0xFF) << 16;
                bits6 = ((bits24 |= (octetString[i++] & 0xFF) << 8) & 0xFC0000) >> 18;
                out[outIndex++] = this.alphabet[bits6];
                bits6 = (bits24 & 0x3F000) >> 12;
                out[outIndex++] = this.alphabet[bits6];
                bits6 = (bits24 & 0xFC0) >> 6;
                out[outIndex++] = this.alphabet[bits6];
                bits6 = bits24 & 0x3F;
                out[outIndex++] = this.alphabet[bits6];
            }
            if (octetString.length - i == 2) {
                bits24 = (octetString[i] & 0xFF) << 16;
                bits6 = ((bits24 |= (octetString[i + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
                out[outIndex++] = this.alphabet[bits6];
                bits6 = (bits24 & 0x3F000) >> 12;
                out[outIndex++] = this.alphabet[bits6];
                bits6 = (bits24 & 0xFC0) >> 6;
                out[outIndex++] = this.alphabet[bits6];
                out[outIndex++] = 61;
            } else if (octetString.length - i == 1) {
                bits24 = (octetString[i] & 0xFF) << 16;
                bits6 = (bits24 & 0xFC0000) >> 18;
                out[outIndex++] = this.alphabet[bits6];
                bits6 = (bits24 & 0x3F000) >> 12;
                out[outIndex++] = this.alphabet[bits6];
                out[outIndex++] = 61;
                out[outIndex++] = 61;
            }
            return new String(out);
        }
    }
}

