/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Interface.h,v 1.2 2004/09/08 05:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef __INTERFACE_HH_FLAG__
#define __INTERFACE_HH_FLAG__

#include <string>

#include <fwbuilder/Address.h>
#include <fwbuilder/IPv4.h>
#include <fwbuilder/physAddress.h>
#include <fwbuilder/FWException.h>

namespace libfwbuilder
{

class Interface : public Address
{
    private:

    /*
     * @param _bcast_bits The value of the least-significant bit in the IP
     *                   broadcast address used for sending datagrams on
     *                   the (logical) interface associated with the IP
     *                   address of this entry.  For example, when the
     *                   Internet standard all-ones broadcast address is
     *                   used, the value will be 1.  This value applies to
     *                   both the subnet and network broadcasts addresses
     *                   used by the entity on this (logical) interface."
     *
     * @param _snmp_type type of interface, as described in RFC-1213 under
     *                   'ifType' variable description.
     * @param _ostatus,  interface operational status. 'true' means up.
     *
     * These attrbites are not stored in XML yet.
     */
    
    int  bcast_bits;
    bool ostatus;
    int  snmp_type;

    public:
    
    Interface();
    Interface(const FWObject *root);
    Interface(const Interface &i);
    virtual ~Interface();


    virtual void fromXML(xmlNodePtr parent) throw(FWException);
    virtual xmlNodePtr toXML      (xmlNodePtr parent) throw(FWException);

    virtual bool  validateChild(FWObject *o);

    DECLARE_FWOBJECT_SUBTYPE(Interface);

    /**
     *   each interface must be associated with some security level. Level
     *   is described by interger number between 0 and 100, with 0 being
     *   least secure and 100 most secure levels. By default class Interface
     *   assigns value of 0 to its security level.
     */
    int  getSecurityLevel() const;
    void setSecurityLevel(int level);

    /**
     *   Convenience methods: interface is considered "external" if its
     *   security level is 0
     */
    void setExt(bool value);
    bool isExt() const ;

    void setDyn(bool value);
    bool isDyn() const ;

    void setUnnumbered(bool value);
    bool isUnnumbered() const ;

    void setManagement(bool value);
    bool isManagement() const;

    bool isUp () const { return ostatus; }
    void setOStatus(bool value);

    void setInterfaceType(int _snmp_type);
    int  getInterfaceType() const { return snmp_type; }

    void setBroadcastBits(int _val);

    /**
     * returns true if interface is loopback. Should work correctly
     * for both ipv4 and ipv6 (some day)
     */
    bool isLoopback() const;

    const IPAddress  getIPAddress       () const throw(FWException);

    IPv4*  addIPv4();

    physAddress*  getPhysicalAddress () const;
    void  setPhysicalAddress(const std::string &pa);


    IPNetwork getIPNetwork() const throw(FWException);
    
    virtual FWObject& shallowDuplicate(const FWObject *obj, bool preserve_id = true) throw(FWException);
    virtual FWObject& duplicate(const FWObject *obj, bool preserve_id = true) throw(FWException);

    const std::string &getLabel() const;
    void          setLabel(const std::string& n);
    
    virtual IPAddress getAddress() const;
    virtual Netmask   getNetmask() const;
    virtual guint32   dimension()  const;

    virtual void setAddress(const IPAddress &a);
    virtual void setNetmask(const Netmask   &nm);
    virtual void setAddress(const std::string &a);
    virtual void setNetmask(const std::string &nm);

};

}

#endif


