/* 
 * $Id: ctkentry.h,v 1.8 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTKENTRY_H__
# define __CTKENTRY_H__ 

typedef struct CtkEntry_S {
	CtkEditable editable;

} CtkEntry;

#define CTK_ENTRY(obj)	CTK_CHECK_CAST((obj),CtkEntry,CtkTypeEntry)

void ctk_entry_init(CtkEntry *entry);
CtkWidget *ctk_entry_new();
void ctk_entry_set_text(CtkEntry *entry, const gchar *text);
void ctk_entry_set_visibility(CtkEntry *entry, gboolean visible);
gchar *ctk_entry_get_text(CtkEntry *entry);
void ctk_entry_set_max_length(CtkEntry *entry, guint16 max);

#endif
