<?php
// File           acc_procr.php / ibWebAdmin
// Purpose        html sequence for the procedures panel on the accessories page
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <02/10/16 14:23:19 lb>
//
// $Id: acc_proc.php,v 1.5 2004/03/07 17:08:37 lbrueckner Exp $


if (isset($s_confirmations['procedure'])) {
    $subject = 'procedure';
    include_once('panels/confirm.php');
}

elseif (isset($proc_add_flag)) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="create_proc_form">
<?php hidden_session_field();
      procedure_definition($acc_strings['CreateProc']);
 ?>
<input type="submit" name="acc_proc_create_cancel" value="<?php echo $button_strings['Cancel']; ?>">&nbsp;&nbsp;&nbsp;
<input type="reset" name="acc_proc_create_clear" value="<?php echo $button_strings['Reset']; ?>">&nbsp;&nbsp;&nbsp;
<input type="submit" name="acc_proc_create_doit" value="<?php echo $button_strings['Create']; ?>">
</form>
<?php

} elseif (isset($proc_mod_flag)) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="modify_proc_form">
<?php 
      hidden_session_field();
      procedure_definition(sprintf($acc_strings['ModProc'], $s_proceduredefs['name']));
?>
<input type="submit" name="acc_proc_mod_cancel" value="<?php echo $button_strings['Cancel']; ?>">&nbsp;&nbsp;&nbsp;
<input type="reset" name="acc_proc_mod_clear" value="<?php echo $button_strings['Reset']; ?>">&nbsp;&nbsp;&nbsp;
<input type="submit" name="acc_proc_mod_doit" value="<?php echo $button_strings['Save']; ?>">
</form>
<?php

} elseif ($s_connected == TRUE) {

    if (count($s_procedures) > 0) {
        foreach($s_procedures as $pname => $properties) {

            $fold_url = fold_detail_url('procedure', $properties['status'], $pname, $pname);

            echo '<div id="'.'p_'.$pname."\" style=\"border-bottom: 1px solid black; margin: 1px;\">\n";

            if ($properties['status'] == 'open') {

                echo get_opened_procedure($pname, $properties, $fold_url);
            }
            else {

                echo get_closed_detail($pname, $fold_url);
            }

            echo "</div>\n";
        }
    }

    echo '<form method="post" action="'.$HTTP_SERVER_VARS['PHP_SELF']."\" name=\"acc_proc_form\">\n";

    if (count($s_procedures) > 0) {
        echo '<input type="submit" name="acc_proc_reload" value="'.$button_strings['Reload']."\">&nbsp;&nbsp;&nbsp;\n";

        if (count($s_procedures) > 1) {
            echo '<input type="submit" name="acc_proc_open" value="'.$button_strings['OpenAll']."\">&nbsp;&nbsp;&nbsp;\n";
            echo '<input type="submit" name="acc_proc_close" value="'.$button_strings['CloseAll']."\">\n";
            
        }
        echo "<br><br>\n";
    }

    hidden_session_field();

?>
<table border cellpadding="3" cellspacing="0">
<tr>
  <th  colspan="2" align="left"><?php echo $acc_strings['CreateProc']; ?></th>
  <td><input type="submit" name="acc_proc_create" value="<?php echo $button_strings['Create']; ?>"></td>
</tr>
<tr>
  <td>
    <b><?php echo $acc_strings['SelProcMod']; ?></b>
  </td>
  <td>
    <?php echo get_selectlist('acc_proc_mod_name', array_keys($s_procedures), NULL, TRUE); ?>
  </td>
  <td align="left">
    <input type="submit" name="acc_proc_mod" value="<?php echo $button_strings['Modify']; ?>">
  </td>
</tr>
<tr>
  <td>
    <b><?php echo $acc_strings['SelProcDel']; ?></b>
  </td>
  <td>
    <?php echo get_selectlist('acc_proc_del_name', array_keys($s_procedures), NULL, TRUE); ?>
  </td>
  <td align="left">
    <input type="submit" name="acc_proc_del" value="<?php echo $button_strings['Delete']; ?>">
  </td>
</tr>
</table>
</form>
<?php

}

?>
