/*
 *
 *    Copyright 1995-2001 Regents of the University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file AUTHORS for a list of contributors.
 *
 *    This file was maintained by:
 *      David C. Teigland  <teigland@sistina.com>
 *
 */

#include <string.h>
#include "osi_endian.h"

#include "cluster_config.h"

#define CPIN_8(x, y, z) {memcpy((x), (y), (z));}
#define CPOUT_8(x, y, z) {memcpy((y), (x), (z));}
#define CPIN_16(x, y) {(x) = be16_to_cpu((y));}
#define CPOUT_16(x, y) {(y) = cpu_to_be16((x));}
#define CPIN_32(x, y) {(x) = be32_to_cpu((y));}
#define CPOUT_32(x, y) {(y) = cpu_to_be32((x));}
#define CPIN_64(x, y) {(x) = be64_to_cpu((y));}
#define CPOUT_64(x, y) {(y) = cpu_to_be64((x));}

int
ondisk_stomith_size(uint32 magic)
{
	struct cluster_stomith cs;
	int base = sizeof(cs.cs_magic) + sizeof(cs.cs_name);

	switch (magic) {
	case STM_BRCD_ZONE:
		return (base + sizeof(struct stm_brcd_zone));

	case STM_BRCD_PORT:
		return (base + sizeof(struct stm_brcd_port));

	case STM_WTI_NPS:
		return (base + sizeof(struct stm_wti_nps));

	case STM_VACM_EMP:
		return (base + sizeof(struct stm_vacm_emp));

	case STM_GNBD:
		return (base + sizeof(struct stm_gnbd));

	case STM_MEATWARE:
		return (base + sizeof(struct stm_meatware));

	case STM_VXHUB_BYPASS:
		return (base + sizeof(struct stm_vx_hub));

	case STM_APC_MS:
		return (base + sizeof(struct stm_apc_ms));

	default:
		return (0);
	}
}

static void
stm_brcd_zone_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_32(cs->cs_st.brcd_zone_s.st_ipaddr,
		bufcs->cs_st.brcd_zone_s.st_ipaddr);
	CPIN_32(cs->cs_st.brcd_zone_s.st_kernel_code,
		bufcs->cs_st.brcd_zone_s.st_kernel_code);
	CPIN_8(cs->cs_st.brcd_zone_s.st_login,
	       bufcs->cs_st.brcd_zone_s.st_login, STM_STRING_LEN);
	CPIN_8(cs->cs_st.brcd_zone_s.st_passwd,
	       bufcs->cs_st.brcd_zone_s.st_passwd, STM_STRING_LEN);
	CPIN_8(cs->cs_st.brcd_zone_s.st_command,
	       bufcs->cs_st.brcd_zone_s.st_command, STM_STRING_LEN);
	CPIN_8(cs->cs_st.brcd_zone_s.st_cfgname,
	       bufcs->cs_st.brcd_zone_s.st_cfgname, STM_STRING_LEN);
	CPIN_8(cs->cs_st.brcd_zone_s.st_comzone,
	       bufcs->cs_st.brcd_zone_s.st_comzone, STM_STRING_LEN);
	CPIN_8(cs->cs_st.brcd_zone_s.st_actname,
	       bufcs->cs_st.brcd_zone_s.st_actname, STM_STRING_LEN);
}

static void
stm_brcd_zone_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_32(cs->cs_st.brcd_zone_s.st_ipaddr,
		 bufcs->cs_st.brcd_zone_s.st_ipaddr);
	CPOUT_32(cs->cs_st.brcd_zone_s.st_kernel_code,
		 bufcs->cs_st.brcd_zone_s.st_kernel_code);
	CPOUT_8(cs->cs_st.brcd_zone_s.st_login,
		bufcs->cs_st.brcd_zone_s.st_login, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.brcd_zone_s.st_passwd,
		bufcs->cs_st.brcd_zone_s.st_passwd, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.brcd_zone_s.st_command,
		bufcs->cs_st.brcd_zone_s.st_command, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.brcd_zone_s.st_cfgname,
		bufcs->cs_st.brcd_zone_s.st_cfgname, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.brcd_zone_s.st_comzone,
		bufcs->cs_st.brcd_zone_s.st_comzone, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.brcd_zone_s.st_actname,
		bufcs->cs_st.brcd_zone_s.st_actname, STM_STRING_LEN);
}

static void
stm_brcd_port_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_32(cs->cs_st.brcd_port_s.st_ipaddr,
		bufcs->cs_st.brcd_port_s.st_ipaddr);
	CPIN_32(cs->cs_st.brcd_port_s.st_kernel_code,
		bufcs->cs_st.brcd_port_s.st_kernel_code);
	CPIN_8(cs->cs_st.brcd_port_s.st_login,
	       bufcs->cs_st.brcd_port_s.st_login, STM_STRING_LEN);
	CPIN_8(cs->cs_st.brcd_port_s.st_passwd,
	       bufcs->cs_st.brcd_port_s.st_passwd, STM_STRING_LEN);
	CPIN_32(cs->cs_st.brcd_port_s.st_port,
		bufcs->cs_st.brcd_port_s.st_port);
}

static void
stm_brcd_port_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_32(cs->cs_st.brcd_port_s.st_ipaddr,
		 bufcs->cs_st.brcd_port_s.st_ipaddr);
	CPOUT_32(cs->cs_st.brcd_port_s.st_kernel_code,
		 bufcs->cs_st.brcd_port_s.st_kernel_code);
	CPOUT_8(cs->cs_st.brcd_port_s.st_login,
		bufcs->cs_st.brcd_port_s.st_login, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.brcd_port_s.st_passwd,
		bufcs->cs_st.brcd_port_s.st_passwd, STM_STRING_LEN);
	CPOUT_32(cs->cs_st.brcd_port_s.st_port,
		 bufcs->cs_st.brcd_port_s.st_port);
}

static void
stm_wti_nps_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_32(cs->cs_st.wti_nps_s.st_ipaddr,
		bufcs->cs_st.wti_nps_s.st_ipaddr);
	CPIN_32(cs->cs_st.wti_nps_s.st_kernel_code,
		bufcs->cs_st.wti_nps_s.st_kernel_code);
	CPIN_8(cs->cs_st.wti_nps_s.st_passwd, bufcs->cs_st.wti_nps_s.st_passwd,
	       STM_STRING_LEN);
	CPIN_32(cs->cs_st.wti_nps_s.st_plug, bufcs->cs_st.wti_nps_s.st_plug);
}

static void
stm_wti_nps_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_32(cs->cs_st.wti_nps_s.st_ipaddr,
		 bufcs->cs_st.wti_nps_s.st_ipaddr);
	CPOUT_32(cs->cs_st.wti_nps_s.st_kernel_code,
		 bufcs->cs_st.wti_nps_s.st_kernel_code);
	CPOUT_8(cs->cs_st.wti_nps_s.st_passwd, bufcs->cs_st.wti_nps_s.st_passwd,
		STM_STRING_LEN);
	CPOUT_32(cs->cs_st.wti_nps_s.st_plug, bufcs->cs_st.wti_nps_s.st_plug);
}

static void
stm_vacm_emp_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_8(cs->cs_st.vacm_emp_s.st_nexxus,
	       bufcs->cs_st.vacm_emp_s.st_nexxus, STM_STRING_LEN);
	CPIN_8(cs->cs_st.vacm_emp_s.st_login, bufcs->cs_st.vacm_emp_s.st_login,
	       STM_STRING_LEN);
	CPIN_8(cs->cs_st.vacm_emp_s.st_passwd,
	       bufcs->cs_st.vacm_emp_s.st_passwd, STM_STRING_LEN);
	CPIN_8(cs->cs_st.vacm_emp_s.st_nodeid,
	       bufcs->cs_st.vacm_emp_s.st_nodeid, STM_STRING_LEN);
}

static void
stm_vacm_emp_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_8(cs->cs_st.vacm_emp_s.st_nexxus,
		bufcs->cs_st.vacm_emp_s.st_nexxus, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.vacm_emp_s.st_login, bufcs->cs_st.vacm_emp_s.st_login,
		STM_STRING_LEN);
	CPOUT_8(cs->cs_st.vacm_emp_s.st_passwd,
		bufcs->cs_st.vacm_emp_s.st_passwd, STM_STRING_LEN);
	CPOUT_8(cs->cs_st.vacm_emp_s.st_nodeid,
		bufcs->cs_st.vacm_emp_s.st_nodeid, STM_STRING_LEN);
}

static void
stm_gnbd_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_32(cs->cs_st.gnbd_s.st_ipaddr, bufcs->cs_st.gnbd_s.st_ipaddr);
}

static void
stm_gnbd_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_32(cs->cs_st.gnbd_s.st_ipaddr, bufcs->cs_st.gnbd_s.st_ipaddr);
}

static void
stm_meatware_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_32(cs->cs_st.meatware_s.st_ipaddr,
		bufcs->cs_st.meatware_s.st_ipaddr);
}

static void
stm_meatware_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_32(cs->cs_st.meatware_s.st_ipaddr,
		 bufcs->cs_st.meatware_s.st_ipaddr);
}

static void
stm_vx_hub_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_32(cs->cs_st.vx_hub_s.st_ipaddr, bufcs->cs_st.vx_hub_s.st_ipaddr);
	CPIN_8(cs->cs_st.vx_hub_s.st_passwd, bufcs->cs_st.vx_hub_s.st_passwd,
	       STM_STRING_LEN);
	CPIN_32(cs->cs_st.vx_hub_s.st_port, bufcs->cs_st.vx_hub_s.st_port);
}

static void
stm_vx_hub_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_32(cs->cs_st.vx_hub_s.st_ipaddr, bufcs->cs_st.vx_hub_s.st_ipaddr);
	CPOUT_8(cs->cs_st.vx_hub_s.st_passwd, bufcs->cs_st.vx_hub_s.st_passwd,
		STM_STRING_LEN);
	CPOUT_32(cs->cs_st.vx_hub_s.st_port, bufcs->cs_st.vx_hub_s.st_port);
}

static void
stm_apc_ms_in(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPIN_32(cs->cs_st.apc_ms_s.st_ipaddr, bufcs->cs_st.apc_ms_s.st_ipaddr);
	CPIN_32(cs->cs_st.apc_ms_s.st_outlet, bufcs->cs_st.apc_ms_s.st_outlet);
	CPIN_8(cs->cs_st.apc_ms_s.st_login, bufcs->cs_st.apc_ms_s.st_login,
	       STM_STRING_LEN);
	CPIN_8(cs->cs_st.apc_ms_s.st_passwd, bufcs->cs_st.apc_ms_s.st_passwd,
	       STM_STRING_LEN);
}

static void
stm_apc_ms_out(struct cluster_stomith *cs, struct cluster_stomith *bufcs)
{
	CPOUT_32(cs->cs_st.apc_ms_s.st_ipaddr, bufcs->cs_st.apc_ms_s.st_ipaddr);
	CPOUT_32(cs->cs_st.apc_ms_s.st_outlet, bufcs->cs_st.apc_ms_s.st_outlet);
	CPOUT_8(cs->cs_st.apc_ms_s.st_login, bufcs->cs_st.apc_ms_s.st_login,
		STM_STRING_LEN);
	CPOUT_8(cs->cs_st.apc_ms_s.st_passwd, bufcs->cs_st.apc_ms_s.st_passwd,
		STM_STRING_LEN);
}

void
cluster_stomith_in(struct cluster_stomith *cs, char *buf)
{
	struct cluster_stomith *bufcs = (struct cluster_stomith *) buf;

	CPIN_32(cs->cs_magic, bufcs->cs_magic);
	CPIN_8(cs->cs_name, bufcs->cs_name, STM_STRING_LEN);

	switch (cs->cs_magic) {
	case STM_BRCD_ZONE:
		stm_brcd_zone_in(cs, bufcs);
		break;

	case STM_BRCD_PORT:
		stm_brcd_port_in(cs, bufcs);
		break;

	case STM_WTI_NPS:
		stm_wti_nps_in(cs, bufcs);
		break;

	case STM_VACM_EMP:
		stm_vacm_emp_in(cs, bufcs);
		break;

	case STM_GNBD:
		stm_gnbd_in(cs, bufcs);
		break;

	case STM_MEATWARE:
	case STM_MANUAL:
		stm_meatware_in(cs, bufcs);
		break;

	case STM_VXHUB_BYPASS:
		stm_vx_hub_in(cs, bufcs);
		break;

	case STM_APC_MS:
		stm_apc_ms_in(cs, bufcs);
		break;
	}
}

void
cluster_stomith_out(struct cluster_stomith *cs, char *buf)
{
	struct cluster_stomith *bufcs = (struct cluster_stomith *) buf;

	CPOUT_32(cs->cs_magic, bufcs->cs_magic);
	CPOUT_8(cs->cs_name, bufcs->cs_name, STM_STRING_LEN);

	switch (cs->cs_magic) {
	case STM_BRCD_ZONE:
		stm_brcd_zone_out(cs, bufcs);
		break;

	case STM_BRCD_PORT:
		stm_brcd_port_out(cs, bufcs);
		break;

	case STM_WTI_NPS:
		stm_wti_nps_out(cs, bufcs);
		break;

	case STM_VACM_EMP:
		stm_vacm_emp_out(cs, bufcs);
		break;

	case STM_GNBD:
		stm_gnbd_out(cs, bufcs);
		break;

	case STM_MEATWARE:
	case STM_MANUAL:
		stm_meatware_out(cs, bufcs);
		break;

	case STM_VXHUB_BYPASS:
		stm_vx_hub_out(cs, bufcs);
		break;

	case STM_APC_MS:
		stm_apc_ms_out(cs, bufcs);
		break;
	}
}

/*  Nothing STOMITH-specific below  */

void
cluster_global_in(cluster_global_t * cg, char *buf)
{
	cluster_global_t *bufcg = (cluster_global_t *) buf;

	CPIN_32(cg->cg_magic, bufcg->cg_magic);
	CPIN_32(cg->cg_version, bufcg->cg_version);

	CPIN_8(cg->cg_lockdev, bufcg->cg_lockdev, OGFS_LOCKNAME_LEN);
	CPIN_8(cg->cg_datadev, bufcg->cg_datadev, OGFS_LOCKNAME_LEN);

	CPIN_32(cg->cg_cbport, bufcg->cg_cbport);
	CPIN_32(cg->cg_node_timeout, bufcg->cg_node_timeout);
}

void
cluster_global_out(cluster_global_t * cg, char *buf)
{
	cluster_global_t *bufcg = (cluster_global_t *) buf;

	CPOUT_32(cg->cg_magic, bufcg->cg_magic);
	CPOUT_32(cg->cg_version, bufcg->cg_version);

	CPOUT_8(cg->cg_lockdev, bufcg->cg_lockdev, OGFS_LOCKNAME_LEN);
	CPOUT_8(cg->cg_datadev, bufcg->cg_datadev, OGFS_LOCKNAME_LEN);

	CPOUT_32(cg->cg_cbport, bufcg->cg_cbport);
	CPOUT_32(cg->cg_node_timeout, bufcg->cg_node_timeout);
}

void
cluster_node_in(cluster_node_t * cn, char *buf)
{
	cluster_node_t *bufcn = (cluster_node_t *) buf;

	CPIN_32(cn->cn_magic, bufcn->cn_magic);
	CPIN_32(cn->cn_ipaddr, bufcn->cn_ipaddr);
	CPIN_32(cn->cn_cid, bufcn->cn_cid);
	CPIN_32(cn->cn_num_stomith, bufcn->cn_num_stomith);
}

void
cluster_node_out(cluster_node_t * cn, char *buf)
{
	cluster_node_t *bufcn = (cluster_node_t *) buf;

	CPOUT_32(cn->cn_magic, bufcn->cn_magic);
	CPOUT_32(cn->cn_ipaddr, bufcn->cn_ipaddr);
	CPOUT_32(cn->cn_cid, bufcn->cn_cid);
	CPOUT_32(cn->cn_num_stomith, bufcn->cn_num_stomith);
}
