/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: handlemgr.h
 */

/*
 * Global functions exported by handlemgr.c
 */
extern boolean initialize_handle_manager(void);

extern int create_handle(void *            object,
                         object_type_t     object_type,
                         object_handle_t * handle);

extern int destroy_handle(object_handle_t handle);

extern int destroy_all_handles(void);

extern int translate_handle(object_handle_t handle,
                            void          * object,
                            object_type_t * object_type);


/*
 * The following defines represent the error codes that can be returned by this
 * module.
 */

#define HANDLE_MANAGER_NO_ERROR          0
#define HANDLE_MANAGER_NOT_INITIALIZED   221
#define HANDLE_MANAGER_BAD_HANDLE        222

/* Macro to determine if an error code is a handle manager error code. */

#define IS_HANDLE_MANAGER_ERROR(rc) ((abs(rc) >= HANDLE_MANAGER_NOT_INITIALIZED) && (abs(rc) <= HANDLE_MANAGER_BAD_HANDLE))

static inline const char * handlemgr_strerror(int err_num) {

	if (err_num == HANDLE_MANAGER_NOT_INITIALIZED) {
		return "Handle manager not initialized";
	}

	if (err_num == HANDLE_MANAGER_BAD_HANDLE) {
		return "Bad handle for handle manager";
	}

	return "";
}
