#! /usr/local/bin/python -O
"""Darkstat API example.

This file is a part of darkstat (http://purl.org/net/darkstat)
Author: Oleg Broytmann <phd@phd.pp.ru>
License: GPL
"""


import sys
from darkstat import DEFAULT_HOST, DEFAULT_PORT
from darkstat.info_txt import DarkstatAPI


if len(sys.argv) == 1:
   host = DEFAULT_HOST
   port = DEFAULT_PORT

elif len(sys.argv) == 2:
   host = sys.argv[1]
   port = DEFAULT_PORT

elif len(sys.argv) == 3:
   host = sys.argv[1]
   port = int(sys.argv[2])

else:
   sys.exit("Usage: %s [host [port]]" % sys.argv[0])


print "Trying darkstat at %s:%s" % (host, port)
darkstat = DarkstatAPI(host, port)


bytes_total = darkstat.get_total_bytes()
print "Total bytes:", bytes_total
