/*
 * Copyright (c) 2003 Brian Kreulen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __CHOICEDLG_H__
#define __CHOICEDLG_H__

#include "_choicedlg.h"

class QString;
class QWidget;
class ArsonListHeader;
class QListViewItem;

class ArsonChoiceDlg : public ArsonChoiceDlgBase {
   Q_OBJECT

public:
    ArsonChoiceDlg(ArsonListHeader headers[], int headerCnt, QWidget *parent);

    void addChoice(const QString &id, const QString &artist, const QString &name);
    void setHeaders(ArsonListHeader *headers);
    void setDescription(const QString &str);
    void selectFirst();

    const QString getSelectedId();

protected slots:
    virtual void accept();
    virtual void reject();

public slots:
    virtual void dblClicked(QListViewItem *pItem, const QPoint &point, int count);

private:
    QListViewItem *m_pLast;
};

#endif	/*	__CHOICEDLG_H__	*/
