/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	A cdindex interface for arson
 *	0x960b580b
 *	GET /~cddb/cddb.cgi?cmd=cddb+read+misc+960b580b&hello=tonys111+jimmy+arson+0.9.3&proto=5
 *	by Tony Sideris	(05:27PM Sep 18, 2001)
 *================================================*/
#include "arson.h"

#include <qregexp.h>

#include <klocale.h>
#include <kstddirs.h>

#include "cdindex.h"
#include "konfig.h"

/*========================================================*/
/*	The CDINDEX socket class
 *========================================================*/

ArsonCdindexSocket::ArsonCdindexSocket(
	const QString &cdIndex, const QString &host, short port)
	: ArsonHttpGetSocket(host, port), m_cdIndex(cdIndex)
{
	//	Nothing...
}

/*========================================================*/

QString ArsonCdindexSocket::path (void) const
{
	return QString("/cgi-bin/cdi/xget.pl");
}

QString ArsonCdindexSocket::request (void) const
{
	ArsonHttpCommand cmd ("id");
	cmd << m_cdIndex;

	return cmd.command();
}

/*========================================================*/
/*	The cdindex parser implementation
 *========================================================*/

ArsonCdInfo::Track ArsonCdindexParser::toTrack (const QXmlAttributes &attr)
{
	ArsonCdInfo::Track track;

	//	Parse the elements attributes into variables...
	for (int index = 0; index < attr.length(); index++)
	{
		const QString name = attr.qName(index).lower();

		if (name == "num")
			track.setTrackNo(attr.value(index).toInt());
	}

	return track;
}

/*========================================================*/

bool ArsonCdindexParser::use (ArsonCdInfo::Track &track,
	const QString &tag, const QString &data)
{
	if (tag == "name")
		track.setTitle(data);

	else if (tag == "artist")
		track.setArtist(data);

	else
		return false;

	return true;
}

/*========================================================*/

bool ArsonCdindexParser::use (ArsonCdInfo &info, const QString &tag, const QString &data)
{
	if (tag == "title")
		info.setTitle(data);
/*
	else if (tag == "numtracks")
		info.setTrackCount(data.toInt());
*/
	else if (tag == "artist")
		info.setArtist(data);

	else
		return false;

	return true;
}

/*========================================================*/

bool ArsonCdindexParser::startElement (const QString &namespaceURI,
	const QString &local, const QString &name, const QXmlAttributes &attr)
{
	const QString *tagName = new QString(name.lower());

	m_tagStack.push(tagName);

	if (*tagName == "track")
	{
		ArsonCdInfo::Track track = toTrack(attr);

		m_pCurTrack = &(
			m_info.addTrack(track));
	}
	
	return true;
}

/*========================================================*/

bool ArsonCdindexParser::endElement (const QString &namespaceURI,
	const QString &local, const QString &name)
{
	const QString *tagName = m_tagStack.pop();

	if (*tagName == "track")
		m_pCurTrack = NULL;

	delete tagName;
	return true;
}

/*========================================================*/

bool ArsonCdindexParser::characters (const QString &chars)
{
	if (!m_tagStack.isEmpty())
	{
		const QString *tagName = m_tagStack.top();

		if (m_pCurTrack)
			use(*m_pCurTrack, *tagName, chars);
		else
			use(m_info, *tagName, chars);
	}

	return true;
}

/*========================================================*/
/*	CDINDEX dialog
 *========================================================*/

ArsonCdindexDlg::ArsonCdindexDlg (const ArsonCdInfo &info, const QString &addr, short port)
	: ArsonCdInfoWaitDlg(info), m_addr(addr), m_port(port)
{
	setMessage(
		i18n("Contacting CD Index server for CD information..."));

	setCaption(
		i18n("CD Index"));
}

/*========================================================*/

ArsonSocket *ArsonCdindexDlg::createSocket (void)
{
	return new ArsonCdindexSocket(
		m_info.cdIndexID(),
		m_addr, m_port);
}

/*========================================================*/

void ArsonCdindexDlg::handleStream (QTextStream *pStream)
{
	ArsonCdindexParser parser;

	if (arsonParseXml(pStream, &parser))
	{
		m_info.merge(parser.info());
		accept();
	}
	else
		reject();
}

/*========================================================*/
