/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class HtmlTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected boolean locale = false;
    protected boolean xhtml = false;
    protected boolean lang = false;

    public boolean getLocale() {
        return this.locale;
    }

    public void setLocale(boolean locale) {
        this.locale = locale;
    }

    public boolean getXhtml() {
        return this.xhtml;
    }

    public void setXhtml(boolean xhtml) {
        this.xhtml = xhtml;
    }

    public boolean getLang() {
        return this.lang;
    }

    public void setLang(boolean lang) {
        this.lang = lang;
    }

    public int doStartTag() throws JspException {
        TagUtils.getInstance().write(this.pageContext, this.renderHtmlStartElement());
        return 1;
    }

    protected String renderHtmlStartElement() {
        boolean validCountry;
        StringBuffer sb = new StringBuffer("<html");
        String language = null;
        String country = "";
        if (this.locale) {
            language = this.getCurrentLocale().getLanguage();
        } else {
            Locale currentLocale = TagUtils.getInstance().getUserLocale(this.pageContext, "org.apache.struts.action.LOCALE");
            language = currentLocale.getLanguage();
            country = currentLocale.getCountry();
        }
        boolean validLanguage = language != null && language.length() > 0;
        boolean bl = validCountry = country.length() > 0;
        if (this.xhtml) {
            this.pageContext.setAttribute("org.apache.struts.globals.XHTML", (Object)"true", 1);
            sb.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
        }
        if ((this.lang || this.locale || this.xhtml) && validLanguage) {
            sb.append(" lang=\"");
            sb.append(language);
            if (validCountry) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        if (this.xhtml && validLanguage) {
            sb.append(" xml:lang=\"");
            sb.append(language);
            if (validCountry) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public int doEndTag() throws JspException {
        TagUtils.getInstance().write(this.pageContext, "</html>");
        return 6;
    }

    public void release() {
        this.locale = false;
        this.xhtml = false;
        this.lang = false;
    }

    protected Locale getCurrentLocale() {
        Locale userLocale = TagUtils.getInstance().getUserLocale(this.pageContext, "org.apache.struts.action.LOCALE");
        if (this.locale) {
            HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)userLocale);
        }
        return userLocale;
    }
}

