/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.ValueOverflow;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp00.DataType;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class TimeTranslator
extends CharDataTranslator {
    private static final int TimeSize_C = 8;

    protected TimeTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getTime(sQLParamController, structuredMem, null);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
        }
        return string;
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Time time = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.physicalLength - 1);
            int n = (byArray[0] - 48) * 10;
            n += byArray[1] - 48;
            int n2 = (byArray[3] - 48) * 10;
            n2 += byArray[4] - 48;
            int n3 = (byArray[6] - 48) * 10;
            n3 += byArray[7] - 48;
            if (calendar == null) {
                time = new Time(n, n2, n3);
            } else {
                calendar.clear();
                calendar.set(1970, 0, 1, n, n2, n3);
                time = DBTechTranslator.CalendarUtil.getTimeFromCalendar(calendar);
            }
        }
        return time;
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Time time = this.getTime(sQLParamController, structuredMem, calendar);
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getTime());
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof Time) {
            object2 = this.transTimeForInput((Time)object, Calendar.getInstance());
        }
        return object2;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return this.transTimeForInput(Time.valueOf(string), Calendar.getInstance());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(string);
                return this.transTimeForInput(new Time(timestamp.getTime()), Calendar.getInstance());
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Time");
            }
        }
    }

    public Object transTimeForInput(Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        calendar.setTime(time);
        byte[] byArray = new byte[8];
        int n = calendar.get(11);
        byArray[0] = CharDataTranslator.HighTime_C[n];
        byArray[1] = CharDataTranslator.LowTime_C[n];
        byArray[2] = 58;
        n = calendar.get(12);
        byArray[3] = (byte)(48 + n / 10);
        byArray[4] = (byte)(48 + n % 10);
        byArray[5] = 58;
        n = calendar.get(13);
        byArray[6] = (byte)(48 + n / 10);
        byArray[7] = (byte)(48 + n % 10);
        return byArray;
    }

    protected void putSpecific(DataPart dataPart, Object object) throws SQLException {
        byte[] byArray = (byte[])object;
        if (byArray.length > this.physicalLength - 1) {
            throw new ValueOverflow(DataType.stringValuesC[this.dataType], -1);
        }
        dataPart.putInt1(32, this.bufpos - 1);
        dataPart.putStringBytes(byArray, this.bufpos, this.physicalLength - 1);
    }
}

